/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.crafting;

import com.mrcrayfish.vehicle.crafting.FluidEntry;
import com.mrcrayfish.vehicle.crafting.RecipeType;
import com.mrcrayfish.vehicle.init.ModRecipeSerializers;
import com.mrcrayfish.vehicle.tileentity.FluidMixerTileEntity;
import com.mrcrayfish.vehicle.util.InventoryUtil;
import java.util.Objects;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class FluidMixerRecipe
implements IRecipe<FluidMixerTileEntity> {
    private ResourceLocation id;
    private FluidEntry[] inputs;
    private ItemStack ingredient;
    private FluidEntry result;
    private int hashCode;

    public FluidMixerRecipe(ResourceLocation id, FluidEntry fluidOne, FluidEntry fluidTwo, ItemStack ingredient, FluidEntry result) {
        this.id = id;
        this.inputs = new FluidEntry[]{fluidOne, fluidTwo};
        this.ingredient = ingredient;
        this.result = result;
    }

    public FluidEntry[] getInputs() {
        return this.inputs;
    }

    public ItemStack getIngredient() {
        return this.ingredient;
    }

    public FluidEntry getResult() {
        return this.result;
    }

    public int getFluidAmount(Fluid fluid) {
        for (int i = 0; i < 2; ++i) {
            FluidEntry entry = this.inputs[i];
            if (!entry.getFluid().equals(fluid)) continue;
            return entry.getAmount();
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FluidMixerRecipe)) {
            return false;
        }
        FluidMixerRecipe other = (FluidMixerRecipe)obj;
        int index = -1;
        for (int i = 0; i < 2; ++i) {
            if (!other.inputs[0].getFluid().equals(this.inputs[i].getFluid())) continue;
            index = i == 1 ? 0 : 1;
        }
        if (index == -1) {
            return false;
        }
        if (!other.inputs[1].getFluid().equals(this.inputs[index].getFluid())) {
            return false;
        }
        return InventoryUtil.areItemStacksEqualIgnoreCount(other.ingredient, this.ingredient);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(this.inputs[0].getFluid().getRegistryName(), this.inputs[1].getFluid().getRegistryName(), this.ingredient.func_77973_b().getRegistryName());
        }
        return this.hashCode;
    }

    public boolean matches(FluidMixerTileEntity fluidMixer, World worldIn) {
        if (fluidMixer.getEnderSapTank().isEmpty() || fluidMixer.getBlazeTank().isEmpty()) {
            return false;
        }
        Fluid inputOne = fluidMixer.getEnderSapTank().getFluid().getFluid();
        int index = -1;
        for (int i = 0; i < 2; ++i) {
            if (!inputOne.equals(this.inputs[i].getFluid())) continue;
            index = i == 1 ? 0 : 1;
        }
        if (index == -1) {
            return false;
        }
        Fluid inputTwo = fluidMixer.getBlazeTank().getFluid().getFluid();
        if (!inputTwo.equals(this.inputs[index].getFluid())) {
            return false;
        }
        return InventoryUtil.areItemStacksEqualIgnoreCount(fluidMixer.func_70301_a(1), this.ingredient);
    }

    public ItemStack getCraftingResult(FluidMixerTileEntity inv) {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeSerializers.FLUID_MIXER.get();
    }

    public IRecipeType<?> func_222127_g() {
        return RecipeType.FLUID_MIXER;
    }
}

